/* Copyright (C) 2017 RealVNC Ltd.  All Rights Reserved.
 */

/* This is sample code intended to demonstrate part of the
 * VNC Mobile Solution SDK. It is not intended as a production-ready
 * component.
 */

#include "ControlMessages.h"


ControlMessage::ControlMessage()
{
}

ControlMessageStreamCreateCompleted::ControlMessageStreamCreateCompleted(
        const StreamID streamId)

    :   mStreamId(streamId)
{
}

void ControlMessageStreamCreateCompleted::run(BaseDecoderSupport& support)
{
    support.supportingApiStreamCreateCompleted(mStreamId);
}

ControlMessageStreamStartCompleted::ControlMessageStreamStartCompleted(
        const StreamID streamId)

    :   mStreamId(streamId)
{
}

void ControlMessageStreamStartCompleted::run(BaseDecoderSupport& support)
{
    support.supportingApiStreamStartCompleted(mStreamId);
}

ControlMessageStreamStopCompleted::ControlMessageStreamStopCompleted(
        const StreamID streamId)

    :   mStreamId(streamId)
{
}

void ControlMessageStreamStopCompleted::run(BaseDecoderSupport& support)
{
    support.supportingApiStreamStopCompleted(mStreamId);
}

ControlMessageStreamDestroyCompleted::ControlMessageStreamDestroyCompleted(
        const StreamID streamId)

    :   mStreamId(streamId)
{
}

void ControlMessageStreamDestroyCompleted::run(BaseDecoderSupport& support)
{
    support.supportingApiStreamDestroyCompleted(mStreamId);
}

ControlMessageStreamRecyclePayload::ControlMessageStreamRecyclePayload(
        const StreamID streamId,
        VNCCommonDecoderStreamPayload *const payload)

    :   mStreamId(streamId),
        mPayload(payload)
{
}

void ControlMessageStreamRecyclePayload::run(BaseDecoderSupport& support)
{
    support.supportingApiStreamRecyclePayload(mStreamId, mPayload);
}

